% fcst_psiX_mean_V1.m
% 
% Forecast psiX shares using cosine transformations ... 
%       Linear trend + I(1) model
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
function fcst_psiX_mean_V1

% -- File Directories -- %
% datadir = 'Data/DataReplication/DataFinal/'; 
% outdir = 'Tables/';
% figdir = 'Figures/';
matdir = 'Output/';

% -- Load Data and Setup -- %
load_data;
% n_draws = 5000;
period_lower = 20;       % Shortest Period 
T_is = size(theta,1);
q_is = floor(2*T/period_lower);
per_q_is = 2*T/q_is;
fprintf('Number of cosine transformations for in-sample period: %d\n',q_is);
fprintf('Number of Shortest Periods: %5.1f \n',per_q_is);

Ydata = psiX;

% Construct Forecasts ... univariate ... one for each entry ... note that these are between zero and 1, so impose this constraint
i_base = 2;
for i = 1:size(Ydata,2)
    Share_mat = [Ydata(:,i) 1-Ydata(:,i)];
    X_is = logit_s_to_x(Share_mat,i_base);
    Y = X_is(:,1:end ~= i_base);
    % Get some results from I_1 model
    I_1 = 1;     % Levels data are I(1)
    I_trend = 1; % Include linear trend in the projections
    h_os = T_is;
    [Yproj_is_i, Yproj_os_mean_i, trend_os_only_i] = fcst_y_trend_mean(Y,q_is,h_os,I_1,I_trend);
    T_os = size(Yproj_is_i,1);
    % Get LF estimates of Shares
    Share_is = [Share_mat;NaN(T_os-T_is,size(Share_mat,2))];
    Shareproj_is = logit_y_to_s(Yproj_is_i,i_base);
    Shareproj_os_mean = logit_y_to_s(Yproj_os_mean_i,i_base);
    Share_os_trend_only = logit_y_to_s(trend_os_only_i,i_base);
    if i == 1
        Y_is = Share_is(:,1);
        Yproj_is = Shareproj_is(:,1);
        Yproj_os_mean = Shareproj_os_mean(:,1);
        trend_os_only = Share_os_trend_only(:,1);
    else
        Y_is = [Y_is Share_is(:,1)]; %#ok<*AGROW>
        Yproj_is = [Yproj_is Shareproj_is(:,1)];
        Yproj_os_mean = [Yproj_os_mean Shareproj_os_mean(:,1)];
        trend_os_only = [trend_os_only Share_os_trend_only(:,1)];
    end
end

% Add the trend-only Forecast
Y_os_trend = NaN(size(Yproj_os_mean));
Y_os_trend(T_is+1:end,:) = Yproj_os_mean(T_is,:)+trend_os_only(T_is+1:end,:)-trend_os_only(T_is,:); %#ok<NASGU>

save_variables = {'Y_is','Yproj_os_mean','Yproj_is','Y_os_trend','trend_os_only'};
save([matdir 'fcst_psiX_V1_' num2str(q_is) '.mat'],save_variables{:});









% Y = psiX;
% T_is = size(Y,1);
% nS = size(Y,2);
% SecName_1 = SecName;

% per_is = 2*T_is/q_is;
% fprintf('Number of cosine transformations for in-sample period: %d\n',q_is);
% fprintf('Number of Shortest Periods: %5.1f \n',per_is);

% % Get some results from I_1 model
% I_1 = 1;
% I_trend = 1; % Include linear trend in the projections
% h_os = T_is;
% [Yproj_is Yproj_os_mean trend_os_only] = process_Y_fcst_mean(Y,q_is,h_os,I_1,I_trend);
% T_os = size(Yproj_is,1);

% % Get 
% Y_is = [Y;NaN(T_os-T_is,size(Y,2))];

% % Get fs calendar vector for plotting
% calvec_os = calvec(1)+[0:1:T_os-1]';


% % ax_fs = 15;
% % % Augment the in-sample plot with os forecasts
% % fig2 = figure('Units', 'normalized', 'Position', [0 0 0.5 0.9]); % For Dell Wide Monitor
% % for i = 1:5
% %     subplot(3,2,i);
% %     plot(calvec_os,Y_is(:,i),'- b','LineWidth',1);
% %     hold on;
% %         plot(calvec_os,Yproj_os_mean(:,i),'- b','LineWidth',2);
% %         plot(calvec_os,Yproj_is(:,i),'- k','LineWidth',2);
% %     hold off;
% %     title(SecName{i});
% %     xlim([calvec_os(1) 2050]);
% %     ax = gca;
% %     ax.FontSize = ax_fs;
% % end
% % % figure_to_png(figdir,['fcst_theta_shares_V1_b']);
% % % close(gcf); 

% % Add the trend-only Forecast
% Y_os_trend = NaN(size(Yproj_os_mean));
% Y_os_trend(T_is+1:end,:) = Yproj_os_mean(T_is,:)+trend_os_only(T_is+1:end,:)-trend_os_only(T_is,:);

% % fig3 = figure('Units', 'normalized', 'Position', [0 0 0.5 0.9]); % For Dell Wide Monitor
% % for i = 1:5
% %     subplot(3,2,i);
% %     plot(calvec_os,Y_is(:,i),'- b','LineWidth',1);
% %     hold on;
% %         plot(calvec_os,Yproj_os_mean(:,i),'- b','LineWidth',2);
% %         plot(calvec_os,Y_os_trend(:,i),'-. k','LineWidth',1);
% %         plot(calvec_os,Yproj_is(:,i),'- k','LineWidth',2);
% %     hold off;
% %     title(SecName{i});
% %     xlim([calvec_os(1) 2050]);
% %     ax = gca;
% %     ax.FontSize = ax_fs;
% % end
% % % figure_to_png(figdir,['fcst_theta_shares_V1_c']);
% % % close(gcf); 

% % Save the results
% save_variables = {'Y_is','Yproj_os_mean','Yproj_is','Y_os_trend','trend_os_only'};
% save([matdir 'fcst_psiX_V1.mat'],save_variables{:});
